/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.bwt.JCSerializable;
import jclass.chart.JCAxis;
import jclass.chart.JCChartUtil;

public class JCAxisFormula
implements JCSerializable {
    private JCAxis originator;
    private JCAxis parent;
    double constant;
    double multiplier = 1.0;

    JCAxisFormula(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public synchronized void setConstant(double d) {
        if (this.constant == d) {
            return;
        }
        this.constant = d;
        this.parent.setChanged(true);
    }

    public double getConstant() {
        return this.constant;
    }

    public synchronized void setMultiplier(double d) {
        if (this.multiplier == d) {
            return;
        }
        this.multiplier = d;
        this.parent.setChanged(true);
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public JCAxis getOriginator() {
        return this.originator;
    }

    public synchronized void setOriginator(JCAxis jCAxis) {
        if (this.originator == jCAxis) {
            return;
        }
        if (this.originator == this.parent) {
            throw new IllegalArgumentException("JCAxis cannot be related to itself");
        }
        this.originator = jCAxis;
        this.parent.setChanged(true);
    }

    void calcRelatedParams() {
        if (this.originator == null) {
            return;
        }
        if (this.multiplier == 0.0) {
            return;
        }
        double d = this.multiplier < 0.0 ? -this.multiplier : this.multiplier;
        this.parent.isVertical = this.originator.isVertical;
        this.parent.isReversed = this.originator.isReversed;
        if (this.parent.tickSpacing.isDefault && this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.originator.numSpacing.value * d;
            this.parent.numSpacing.value = JCChartUtil.precCorrect(this.parent.precision.value, this.parent.numSpacing.value);
            if (this.parent.tickSpacing.isDefault) {
                this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
            }
        } else if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
        } else if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.parent.tickSpacing.value * 2.0;
        }
        if (this.multiplier > 0.0) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.max.value * this.multiplier + this.constant;
                return;
            }
            if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.max.value - this.constant) / this.multiplier;
                return;
            }
        } else {
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.max.value * this.multiplier + this.constant;
                return;
            }
            if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        }
    }
}

